// GRSingleRest
/* Revision Control

$Header: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\grphclrp\\grphclob\\grsngrst.cpp,v 1.3 2002-09-09 13:33:57+02 renz Exp $ 

$Id: grsngrst.cpp,v 1.3 2002-09-09 13:33:57+02 renz Exp $ 

$Log: grsngrst.cpp,v $
Revision 1.3  2002-09-09 13:33:57+02  renz
Better boundingRectangle calculation

Revision 1.2  2002-08-29 11:43:36+02  renz
Added RCS Headers
included code for whole-measure-rests.
 

$Author: renz $ 

$Date: 2002-09-09 13:33:57+02 $ 

$Locker:  $ 

$Revision: 1.3 $ 

$Name:  $ 

$RCSfile: grsngrst.cpp,v $ 

$Source: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\grphclrp\\grphclob\\grsngrst.cpp,v $ 

*/
#include "GrphclRp\GrphclOb\GRSngRst.h"
#include "GrphclRp\GrphclOb\GRCmpRst.h"
#include "GrphclRp\GrphclOb\GRTuplet.h"
#include "GrphclRp\GrphclOb\GRStem.h"
#include "GrphclRp\GrphclOb\GRStaff.h"
#include "GrphclRp\GrphclOb\GRSystem.h"
#include "GrphclRp\GrphclOb\GRSysSlc.h"
#include "GrphclRp\GrphclOb\GRGlue.h"
#include "GrphclRp\GrphclOb\Bitmap.h"
#include "GrphclRp\GrphclOb\grdefine.h"
#include "nview.h"


NVPoint GRSingleRest::refposP1;
NVPoint GRSingleRest::refposP2;
NVPoint GRSingleRest::refposP4;
NVPoint GRSingleRest::refposP8;
NVPoint GRSingleRest::refposP16;
NVPoint GRSingleRest::refposP32;
NVPoint GRSingleRest::refposP64;
NVPoint GRSingleRest::refposP128;


// Class GRRest

GRSingleRest::GRSingleRest(GRStaff *grstf,const TYPE_DURATION theDuration)
: GRRest(grstf,new ARRest(theDuration),1) // ownsAR
{
	stemlength = 0;
	firstbar = secondbar = NULL;
	stemdir = GRStem::UP;
	createRest(theDuration);
	// spacing = getSpacing();
	
	curLSPACE = grstf->getStaffLSPACE();

	
}

GRSingleRest::GRSingleRest(GRStaff *grstf,
						   ARRest* abstractRepresentationOfRest)
						   : GRRest(grstf,abstractRepresentationOfRest)
{
	ASSERT(abstractRepresentationOfRest);
	// spacing=getStandardSpacing();
	firstbar = secondbar = NULL;

	stemlength = 0;
	stemdir = GRStem::UP;
	createRest(DURATION_1);
	//## end GRRest::GRRest%851722104.body


}

GRSingleRest::GRSingleRest(GRStaff *grstf,ARRest* abstractRepresentationOfRest,
						   const TYPE_TIMEPOSITION relativeTimePositionOfGRRest,
						   const TYPE_DURATION durationOfGRRest,
						   const TYPE_DURATION p_durtemplate)
						   //## begin GRRest::GRRest%857066088.hasinit preserve=no
						   //## end GRRest::GRRest%857066088.hasinit
						   //## begin GRRest::GRRest%857066088.initialization preserve=yes
						   : GRRest(grstf,abstractRepresentationOfRest,relativeTimePositionOfGRRest,
						   durationOfGRRest)
{
	ASSERT(abstractRepresentationOfRest);
	firstbar = secondbar = NULL;
	stemlength = 0;
	stemdir = GRStem::UP;
	if (p_durtemplate>DURATION_0)
		createRest(p_durtemplate);
	else
		createRest(durationOfGRRest);
	if (durationOfGR == DURATION_0)
		needsSpring = 0;
}


GRSingleRest::~GRSingleRest()
{
}


void GRSingleRest::createRest(const TYPE_DURATION duration)
{
	durtemplate = duration;
	type = P0;
	boundingRectangle.top = 0;
	boundingRectangle.left = 0;
	boundingRectangle.right = 0;
	boundingRectangle.bottom = 0;
	leftSpace = 0;
	rightSpace = 0;
	int typewidth = 0;

	if (duration == DURATION_1)
	{
		type = P1;
		boundingRectangle.top = curLSPACE;
		boundingRectangle.bottom = (int) (1.5 * curLSPACE);
		// boundingRectangle.left = -LSPACE/2;
		// boundingRectangle.right = LSPACE/2;
		leftSpace = (long) ((curLSPACE/2) * size);
		rightSpace = (long) ((curLSPACE/2) * size);

		refposP1.x = 0;
		// refposP1.y = LSPACE;
		position.y = curLSPACE;
	}
	else if (duration == DURATION_2)
	{
		type = P2;
		boundingRectangle.top = (int) (1.5* curLSPACE);
		boundingRectangle.bottom = 2 * curLSPACE;
		//boundingRectangle.left = -LSPACE/2;
		//boundingRectangle.right = LSPACE/2;
		leftSpace = (long) ((curLSPACE/2 * size));
		rightSpace = (long) ((curLSPACE/2 * size));

		refposP2.x = 0;
		// refposP2.y = (long) (1.5 * LSPACE);
		position.y = (long) (1.5 * curLSPACE);

	}
	else if (duration == DURATION_4)
	{
		type = P4;
		boundingRectangle.top = (int) (-2 * curLSPACE);
		typewidth = 1;
		boundingRectangle.bottom = 2* curLSPACE;

		refposP4.x = 0;
		// refposP4.y = 2 * LSPACE;
		position.y = 2* curLSPACE;
	}
	else if (duration == DURATION_8)
	{
		type = P8;
		typewidth = 1;
		boundingRectangle.top = (int) (1.5 * curLSPACE);
		boundingRectangle.bottom = 3 * curLSPACE;

		refposP8.x = 0;
		// refposP8.y = (long) (1.25 * LSPACE);
		position.y = 1.25 * curLSPACE;

	}
	else if (duration == DURATION_16)
	{
		type = P16;
		typewidth = 1;
		boundingRectangle.top = (int) (1.5 * curLSPACE);
		boundingRectangle.bottom = 4 * curLSPACE;

		refposP16.x = 0;
		// refposP16.y = (long) (2.25 * LSPACE);
		position.y = 2.25 * curLSPACE;
	}
	else if (duration == DURATION_32)
	{
		type = P32;
		typewidth = 1;
		boundingRectangle.top = (int) (1.5 * curLSPACE);
		boundingRectangle.bottom = 4 * curLSPACE;

		refposP32.x = 0;
		// refposP32.y = (long) (2.25 * LSPACE);
		position.y = 2.25 * curLSPACE;
	}
	else if (duration == DURATION_64)
	{
		type = P64;
		typewidth = 1;
		boundingRectangle.top = (int) (0.5 * curLSPACE);
		boundingRectangle.bottom = 4 * curLSPACE;

		refposP64.x = 0;
		// refposP64.y = (long) (3.25 * LSPACE);
		position.y = 3.25 * curLSPACE;
	}
	else  if (duration == DURATION_128)
	{
		type = P128;
		typewidth = 1;
		boundingRectangle.top = (int) (0.5 * curLSPACE);
		boundingRectangle.bottom = 4 * curLSPACE;

		refposP128.x = 0;
		// refposP128.y = (long) (4.25 * LSPACE);
		position.y = 4.25 * curLSPACE;
	}
	else
	{ // Unknown Duration ... what do we do know
		type = P0;
		// image = (Image *) fehler;
		boundingRectangle.bottom = 2 * curLSPACE;
	}
	
	/*if (image == NULL)
	{
	image = (Image *) fehler;
	boundingRectangle.bottom = 2 * LSPACE;
} */
	
	//	boundingRectangle.right = ((Bitmap *) image)->getProportionalWidth(getSizeY())
	//			+ boundingRectangle.left;

	if (typewidth)
	{
		long extent = GetCharExtent(type);
		//boundingRectangle.left  = -extent/2;
		//boundingRectangle.right = extent/2;

		leftSpace = (long) (extent/2 * size);
		rightSpace = (long) (extent/2 * size);

	}
	
}

void GRSingleRest::GGSOutput() const
{
}
//## Other Operations (implementation)
void GRSingleRest::OnDraw(HDC hdc) const
{
#ifndef LINUX
	//## begin GRRest::OnDraw%851722105.body preserve=yes
	
/*	HFONT hfontold = (HFONT) SelectObject(hdc,hfontscriab);
	PS_SELECTSCRIABIN
	int nBackmode = GetBkMode(hdc);
	UINT ta = GetTextAlign(hdc);
	SetBkMode(hdc,TRANSPARENT);
	SetTextAlign(hdc,TA_LEFT | TA_BASELINE);
	
	const char c = P8;

	HBRUSH oldbrush;
*/	
	HBRUSH hmybrush = 0;
	HBRUSH holdbrush = 0;
	HPEN hmypen = 0;
	HPEN holdpen = 0;

	switch (type)
	{
	case P1:
		// do something with color ...
		// do something with size ...
		if (colref)
			hmybrush = CreateSolidBrush(RGB(
			colref[0],colref[1],colref[2]));
		if (hmybrush)
			holdbrush = (HBRUSH) SelectObject(hdc,
			hmybrush);
		else
			holdbrush = (HBRUSH) SelectObject(hdc,
			GetStockObject(BLACK_BRUSH));
		
		if (colref)
			hmypen = CreatePen(PS_SOLID,1,
			RGB(colref[0],colref[1],colref[2]));
		if (hmypen)
			holdpen = (HPEN) SelectObject(hdc,
			hmypen);
		

		// draw the rectangle ...
		Rectangle(hdc,
			(long) (position.x - leftSpace + (refposP1.x * size)
			+ offset.x),
			(long) (position.y + (refposP1.y * size)
			+ offset.y),
			(long) (position.x + rightSpace + (refposP1.x * size) +
			offset.x),
			(long) (position.y + (refposP1.y * size) +
				LSPACE/2 + offset.y));
		SelectObject(hdc,holdpen);
		SelectObject(hdc,holdbrush);
		if (hmybrush)
			DeleteObject(hmybrush);
		if (hmypen)
			DeleteObject(hmypen);
		
		break;
	case P2:
		
		// do something with color ...
		// do something with size ...
		if (colref)
			hmybrush = CreateSolidBrush(RGB(
			colref[0],colref[1],colref[2]));
		if (hmybrush)
			holdbrush = (HBRUSH) SelectObject(hdc,
			hmybrush);
		else
			holdbrush = (HBRUSH) SelectObject(hdc,
			GetStockObject(BLACK_BRUSH));
		
		if (colref)
			hmypen = CreatePen(PS_SOLID,1,
			RGB(colref[0],colref[1],colref[2]));
		if (hmypen)
			holdpen = (HPEN) SelectObject(hdc,
			hmypen);
		

		// draw the rectangle ...
		Rectangle(hdc,
			(long) (position.x - leftSpace + (refposP2.x * size)
			+ offset.x),
			(long) (position.y + (refposP2.y * size)
			+ offset.y),
			(long) (position.x + rightSpace + (refposP2.x * size) +
			offset.x),
			(long) (position.y + (refposP2.y * size) +
				LSPACE/2 + offset.y));
		SelectObject(hdc,holdpen);
		SelectObject(hdc,holdbrush);
		if (hmybrush)
			DeleteObject(hmybrush);
		if (hmypen)
			DeleteObject(hmypen);
		
		break;
	case P4:
	case P8:
	case P16:
	case P32:	
	case P64:
	case P128:
		GRRest::OnDrawChar(hdc,type);
		break;
	}
#endif // #ifndef LINUX
}




void GRSingleRest::updateBoundingRectangle()
{
	//## begin GRRest::updateBoundingRectangle%857078558.body preserve=yes
	ASSERT(FALSE); // not implemented
	//## end GRRest::updateBoundingRectangle%857078558.body
}

/* TYPE_SPACING GRSingleRest::getStandardSpacing() const
{
int tmp = GREvent::getStandardSpacing();
tmp -= boundingRectangle.left;
if (tmp<0) return 0;
return tmp;
} */

void GRSingleRest::setPosition(const NVPoint &point)
{
	GREvent::setPosition(point);
	
	if (associated)
		associated->tellPosition(this,position);
	
}



// This is called, when a newline has been intro-
// duced, after the graphical element was drawn
// returns:
// 1, if all is ok
// -1, if not implemented
// 0, if only a part of ndur could be done ...
int GRSingleRest::adjustLength(TYPE_DURATION & ndur)
{
	
	// ATTENTION, ACHTUNG, what happens when
	// the note was within a tuplet!!!!
	// tuplet is not handled yet ....
	
	GRTuplet *mytuplet = NULL;
	
	if (associated)
	{
		POSITION pos = associated->GetHeadPosition();
		GRNotationElement *el;
		while (pos)
		{
			el = associated->GetNext(pos);
			mytuplet = dynamic_cast<GRTuplet *>(el);
			if (mytuplet)
				break;		
		}
	}
	
	if (mytuplet)
		mytuplet->removeEvent(this);
	
	durationOfGR = ndur;
	
	// does it own the stuff? YES
	// rest should not need this?
	elements->RemoveAll();
	
	// create a new Rest (with all its elements)
	createRest(durationOfGR);
	
	// tell all the elements there positions.
	setPosition(position);
	
	if (type == P0)
	{
		// could not handle the duration!
		return 0;
	}
	
	
	return 1;
	
}

int GRSingleRest::getNumFaehnchen(void) const
{
	switch (type)
	{
	case P0:
		return 0;
	case P1:
		return 0;
	case P2:
		return 0;
	case P4:
		return 0;
	case P8:
		return 1;
	case P16:
		return 2;
	case P32:
		return 3;
	case P64:
		return 4;
	case P128:
		return 5;
	
	}
	return 0;

}


NVPoint GRSingleRest::getStemStartPos(void) const
{
	NVPoint pnt(position);
	if (stemdir == GRStem::UP)
	{
		pnt.x += (long) 
			(30 * size +
			offset.x - (4 * size));
		pnt.y -= stemlength 
			- offset.y;
	}
	else if (stemdir == GRStem::DOWN)
	{		
		pnt.x -= (long)
			(30 * size) -
			offset.x;
		pnt.y += stemlength + 
			offset.y;
	}

	return pnt;

}


NVPoint GRSingleRest::getStemEndPos(void) const
{
	NVPoint pnt(position);
	if (stemdir == GRStem::UP)
	{
		pnt.x += (long) 
			((30 * size) +
			offset.x - (1 * size));
		pnt.y -= stemlength 
			- offset.y;
	}
	else if (stemdir == GRStem::DOWN)
	{		
		pnt.x -= (long)
			(30 * size -
			offset.x - (4 * size));
		pnt.y += stemlength + 
			offset.y;
	}
	
	return pnt;

}


void GRSingleRest::setStemDirection(GRStem::STEMDIR pdir)
{
	stemdir = pdir;
}

long GRSingleRest::changeStemLength(long p_length)
{
	return (stemlength = p_length);
}

const NVPoint & GRSingleRest::getReferencePosition() const
{
	switch (type)
	{
	case P0:
		return refposNone;
	case P1:
		return refposP1;
	case P2:
		return refposP2;
	case P4:
		return refposP4;
	case P8:
		return refposP8;
	case P16:
		return refposP16;
	case P32:
		return refposP32;
	case P64:
		return refposP64;
	case P128:
		return refposP128;

	}
	return refposNone;
}

void GRSingleRest::setRestFormat(ARRestFormat *restfrmt)
{
	if (!restfrmt) return;

	float curLSPACE = grstaff->getStaffLSPACE();
	// now we set the position, if it is set ...
	if (restfrmt->getPosy() && restfrmt->getPosy()->TagIsSet())
	{
		position.y = -(restfrmt->getPosy()->getValue(curLSPACE));
	}

	// now we set the offset ...
	if (restfrmt->getDX() && restfrmt->getDX()->TagIsSet())
	{
		offset.x = restfrmt->getDX()->getValue(curLSPACE);
	}
	if (restfrmt->getDY() && restfrmt->getDY()->TagIsSet())
	{
		offset.y = restfrmt->getDY()->getValue(curLSPACE);
	}

	// and the size ...
	if (restfrmt->getSize() && restfrmt->getSize()->TagIsSet())
	{
		
		size = restfrmt->getSize()->getValue(curLSPACE);
	}

	// and color ... (to do )

}

void GRSingleRest::setFillsBar(int value,GRNotationElement *bar1,
							   GRNotationElement *bar2)
{
	fillsbar = value;
	if (fillsbar)
	{
		firstbar = bar1;
		secondbar = bar2;
	}
}
void GRSingleRest::tellPosition(GObject *caller,const NVPoint & newPosition)
{
	if (fillsbar && caller == secondbar)
	{
		// then we have a bar filler ....

		// now we need to check, wether the firstbar exists ...
		// if not, we need the horizontal position of the firstglue
		// of the first systemslice .... 
		float posx = -1;
		if (firstbar)
		{	
			// we need to check, if the systems of the firstbar
			// and secondbar are identical ....
			GRSystem *sys1 = firstbar->getGRStaff()->getGRSystem();
			GRSystem *sys2 = secondbar->getGRStaff()->getGRSystem();
			if (sys1 == sys2)
			{
				posx = firstbar->getPosition().x;
			}
		}
		if ((posx < 0 || !firstbar) && grstaff)
		{
			// this will only work, if we are at
			// the very beginning, and there was no
			// "artificial" begin-slice.
			GRGlue *myglue = grstaff->getSecondGlue();
			if (myglue)
			{
						posx = myglue->getPosition().x;
			}
			else
			{

			GRSystem *grsystem = grstaff->getGRSystem();
			// take the first systemslice ....
			if (grsystem)
			{
				GRSystemSlice *grsysslc = grsystem->getFirstGRSystemSlice();
				if (grsysslc)
				{
					myglue = grsysslc->getEndGlue();
					if (myglue)
					{
						posx = myglue->getPosition().x;
					}
				}
			}
			}
		}

		setHPosition( (secondbar->getPosition().x - posx)/2
			+ posx);
		return;
		
	}
	if (needsSpring == 0 && sprid == -1)
			setHPosition(newPosition.x);

	}
